/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.parser.javascript;

import cz.miroslavbartyzal.psdiagram.app.parser.psd.PSDGrammarParser;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PSDGrammarParserBaseVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PsdToJavaScriptVisitor
extends PSDGrammarParserBaseVisitor<String> {
    private final String input;

    public PsdToJavaScriptVisitor(String input) {
        this.input = input;
    }

    @Override
    public String visitMultiplicative_Expression(PSDGrammarParser.Multiplicative_ExpressionContext ctx) {
        for (ParseTree child : ctx.children) {
            if (child instanceof PSDGrammarParser.Multiplicative_Expression_OperatorContext || child instanceof PSDGrammarParser.Multiplicative_Expression_LeftPartContext || child instanceof PSDGrammarParser.Multiplicative_Expression_RightPartContext) continue;
            throw new IllegalStateException("Unexpected RuleNode!");
        }
        Object result = (String)this.visit(ctx.multiplicative_Expression_LeftPart());
        ArrayList<PSDGrammarParser.Multiplicative_Expression_OperatorContext> operators = new ArrayList<PSDGrammarParser.Multiplicative_Expression_OperatorContext>(ctx.multiplicative_Expression_Operator());
        ArrayList<PSDGrammarParser.Multiplicative_Expression_RightPartContext> rightSideOperands = new ArrayList<PSDGrammarParser.Multiplicative_Expression_RightPartContext>(ctx.multiplicative_Expression_RightPart());
        for (int i = 0; i < operators.size(); ++i) {
            PSDGrammarParser.Multiplicative_Expression_OperatorContext operator = (PSDGrammarParser.Multiplicative_Expression_OperatorContext)operators.get(i);
            result = operator.operator.getType() == 31 ? this.transformToMathFloor((String)result, (String)this.visit(operator), (String)this.visit((ParseTree)rightSideOperands.get(i))) : (String)result + (String)this.visit(operator) + (String)this.visit((ParseTree)rightSideOperands.get(i));
        }
        return result;
    }

    @Override
    public String visitMultiplicative_Expression_LeftPart(PSDGrammarParser.Multiplicative_Expression_LeftPartContext ctx) {
        if (ctx.multiplicative_Expression_LeftPart_ValidLeft() == null || ctx.multiplicative_Expression_Operator() == null || ctx.multiplicative_Expression_Operator().operator.getType() != 31 || ctx.multiplicative_Expression_LeftPart_ValidRight() == null) {
            return (String)super.visitMultiplicative_Expression_LeftPart(ctx);
        }
        String leftOperand = (String)this.visit(ctx.multiplicative_Expression_LeftPart_ValidLeft());
        String operator = (String)this.visit(ctx.multiplicative_Expression_Operator());
        String rightOperand = (String)this.visit(ctx.multiplicative_Expression_LeftPart_ValidRight());
        return this.transformToMathFloor(leftOperand, operator, rightOperand);
    }

    private String transformToMathFloor(String leftOperand, String operator, String rightOperand) {
        String[] leftOperandLSplit = this.splitSpaceLeft(leftOperand);
        String[] operatorRSplit = this.splitSpaceRight(operator);
        String[] rightOperandRSplit = this.splitSpaceRight(rightOperand);
        return leftOperandLSplit[0] + "Math.trunc(" + leftOperandLSplit[1] + "/" + operatorRSplit[1] + rightOperandRSplit[0] + ")" + rightOperandRSplit[1];
    }

    private String[] splitSpaceLeft(String nodeText) {
        String leftOperandTrimmed = nodeText;
        Object spaceLeft = "";
        while (leftOperandTrimmed.matches("^\\s.*")) {
            spaceLeft = (String)spaceLeft + leftOperandTrimmed.substring(0, 1);
            leftOperandTrimmed = leftOperandTrimmed.substring(1);
        }
        return new String[]{spaceLeft, leftOperandTrimmed};
    }

    private String[] splitSpaceRight(String nodeText) {
        String rightOperandTrimmed = nodeText;
        Object spaceRight = "";
        while (rightOperandTrimmed.matches(".*\\s$")) {
            spaceRight = rightOperandTrimmed.substring(rightOperandTrimmed.length() - 1) + (String)spaceRight;
            rightOperandTrimmed = rightOperandTrimmed.substring(0, rightOperandTrimmed.length() - 1);
        }
        return new String[]{rightOperandTrimmed, spaceRight};
    }

    @Override
    public String visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return "";
        }
        String spaceLeft = this.getTerminalSpaceLeft(node.getSymbol().getStartIndex());
        String spaceRight = this.getTerminalSpaceRight(node.getSymbol().getStopIndex());
        String nodeText = node.getSymbol().getType() == 22 ? "==" : node.getText();
        return spaceLeft + nodeText + spaceRight;
    }

    private String getTerminalSpaceLeft(int startIdx) {
        int leftSpaceIdx;
        for (leftSpaceIdx = startIdx; leftSpaceIdx > 0 && this.input.substring(leftSpaceIdx - 1, leftSpaceIdx).matches("\\s"); --leftSpaceIdx) {
        }
        if (leftSpaceIdx != 0) {
            leftSpaceIdx = startIdx;
        }
        return this.input.substring(leftSpaceIdx, startIdx);
    }

    private String getTerminalSpaceRight(int stopIdx) {
        int rightSpaceIdx;
        for (rightSpaceIdx = stopIdx + 1; rightSpaceIdx < this.input.length() && this.input.substring(rightSpaceIdx, rightSpaceIdx + 1).matches("\\s"); ++rightSpaceIdx) {
        }
        return this.input.substring(stopIdx + 1, rightSpaceIdx);
    }

    @Override
    protected String aggregateResult(String aggregate, String nextResult) {
        if (aggregate == null && nextResult == null) {
            return "";
        }
        if (aggregate == null) {
            return nextResult;
        }
        if (nextResult == null) {
            return aggregate;
        }
        return aggregate + nextResult;
    }
}

