/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.parser.psd;

import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.parser.AntlrErrorStrategyTranslated;
import cz.miroslavbartyzal.psdiagram.app.parser.MyAntlrSyntaxErrorListener;
import cz.miroslavbartyzal.psdiagram.app.parser.ParseResult;
import cz.miroslavbartyzal.psdiagram.app.parser.java.PsdToJavaVisitor;
import cz.miroslavbartyzal.psdiagram.app.parser.javascript.PsdToJavaScriptVisitor;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PSDGrammarParser;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PsdGrammarLexerTranslated;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PsdParser;
import cz.miroslavbartyzal.psdiagram.app.parser.psd.PsdParserListener;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;

public class AntlrPsdParser
implements PsdParser {
    private Thread recoveryParseThread = null;

    @Override
    public void stopParsing() {
        if (this.recoveryParseThread != null && this.recoveryParseThread.isAlive()) {
            this.recoveryParseThread.interrupt();
        }
    }

    private PSDGrammarParser createBailOutParser(String input, boolean buildParseTree) {
        PsdGrammarBailLexer lexer = new PsdGrammarBailLexer(CharStreams.fromString(input));
        lexer.removeErrorListeners();
        lexer.addErrorListener(new MyAntlrSyntaxErrorListener(){

            @Override
            public void onSyntaxError(String errorMessage, int beginIndex, int endIndex) {
                throw new RuntimeException();
            }
        });
        PSDGrammarParser parser = new PSDGrammarParser(new CommonTokenStream(lexer));
        parser.setBuildParseTree(buildParseTree);
        parser.removeErrorListeners();
        parser.addErrorListener(new MyAntlrSyntaxErrorListener(){

            @Override
            public void onSyntaxError(String errorMessage, int beginIndex, int endIndex) {
                throw new RuntimeException();
            }
        });
        parser.setErrorHandler(new BailErrorStrategy());
        return parser;
    }

    private boolean parse(String input, RuleCallback ruleCallback) {
        try {
            ruleCallback.ruleCall(this.createBailOutParser(input, false));
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private void parseReportErrors(String input, RuleCallback ruleCallback, PsdParserListener listener) {
        this.stopParsing();
        this.recoveryParseThread = new RecoveryParseThread(input, ruleCallback, listener);
        this.recoveryParseThread.start();
    }

    @Override
    public String translatePSDToJavaScript(String input, Function<PSDGrammarParser, ParseTree> parserRuleChoice) {
        try {
            PSDGrammarParser parser = this.createBailOutParser(input, true);
            PsdToJavaScriptVisitor visitor = new PsdToJavaScriptVisitor(input);
            return (String)visitor.visit(parserRuleChoice.apply(parser));
        }
        catch (RuntimeException ex) {
            return input;
        }
    }

    @Override
    public String translatePSDToJava(String input, Function<PSDGrammarParser, ParseTree> parserRuleChoice) {
        try {
            PSDGrammarParser parser = this.createBailOutParser(input, true);
            PsdToJavaVisitor visitor = new PsdToJavaVisitor(input);
            return (String)visitor.visit(parserRuleChoice.apply(parser));
        }
        catch (RuntimeException ex) {
            return input;
        }
    }

    @Override
    public boolean parseExpression(String input) {
        return this.parse(input, PSDGrammarParser::solo_Expression);
    }

    @Override
    public boolean parseBooleanExpression(String input) {
        return this.parse(input, PSDGrammarParser::solo_BooleanExpression);
    }

    @Override
    public boolean parseListOfConstants(String input) {
        return this.parse(input, PSDGrammarParser::solo_ListOf_Constants);
    }

    @Override
    public boolean parseListOfNumericConstants(String input) {
        return this.parse(input, PSDGrammarParser::solo_ListOf_NumberConstants);
    }

    @Override
    public boolean parseNumericExpression(String input) {
        return this.parse(input, PSDGrammarParser::solo_NumericExpression);
    }

    @Override
    public boolean parseStringExpression(String input) {
        return this.parse(input, PSDGrammarParser::solo_StringExpression);
    }

    @Override
    public boolean parseNoArrayVariableToAssignTo(String input) {
        return this.parse(input, PSDGrammarParser::solo_NoArrayVariableToAssignTo);
    }

    @Override
    public boolean parseVariableToAssignTo(String input) {
        return this.parse(input, PSDGrammarParser::solo_VariableToAssignTo);
    }

    @Override
    public void parseExpressionReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_Expression, listener);
    }

    @Override
    public void parseBooleanExpressionReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_BooleanExpression, listener);
    }

    @Override
    public void parseListOfConstantsReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_ListOf_Constants, listener);
    }

    @Override
    public void parseListOfNumericConstantsExpressionReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_ListOf_NumberConstants, listener);
    }

    @Override
    public void parseNumericExpressionReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_NumericExpression, listener);
    }

    @Override
    public void parseStringExpressionReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_StringExpression, listener);
    }

    @Override
    public void parseNoArrayVariableToAssignToReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_NoArrayVariableToAssignTo, listener);
    }

    @Override
    public void parseVariableToAssignToReportErrors(String input, PsdParserListener listener) {
        this.parseReportErrors(input, PSDGrammarParser::solo_VariableToAssignTo, listener);
    }

    private static class RecoveryParseThread
    extends Thread {
        private final String input;
        private final RuleCallback ruleCallback;
        private final PsdParserListener listener;
        private boolean interrupted = false;

        public RecoveryParseThread(String input, RuleCallback ruleCallback, PsdParserListener listener) {
            this.input = input;
            this.ruleCallback = ruleCallback;
            this.listener = listener;
        }

        private PSDGrammarParser createRecoveryParser(String input, final ParseResult parseResultToSaveTo) {
            PsdGrammarLexerTranslated lexer = new PsdGrammarLexerTranslated(CharStreams.fromString(input));
            lexer.removeErrorListeners();
            lexer.addErrorListener(new MyAntlrSyntaxErrorListener(){

                @Override
                public void onSyntaxError(String errorMessage, int beginIndex, int endIndex) {
                    parseResultToSaveTo.addErrorInfo(errorMessage, beginIndex, endIndex);
                }
            });
            PSDGrammarParser parser = new PSDGrammarParser(new CommonTokenStream(lexer));
            parser.setBuildParseTree(false);
            parser.removeErrorListeners();
            parser.addErrorListener(new MyAntlrSyntaxErrorListener(){

                @Override
                public void onSyntaxError(String errorMessage, int beginIndex, int endIndex) {
                    parseResultToSaveTo.addErrorInfo(errorMessage, beginIndex, endIndex);
                }
            });
            parser.setErrorHandler(new AntlrErrorStrategyTranslated());
            if (!SettingsHolder.IS_DEPLOYMENT_MODE) {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
            }
            return parser;
        }

        @Override
        public void run() {
            this.runSingleStageParse();
        }

        private void runSingleStageParse() {
            final ParseResult parseResult = new ParseResult(this.input);
            this.ruleCallback.ruleCall(this.createRecoveryParser(this.input, parseResult));
            if (!this.interrupted) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (parseResult.isInputValid()) {
                            listener.onValidationComplete(true);
                        } else {
                            listener.onRecoveryFinished(parseResult);
                        }
                    }
                });
            }
        }

        private void runTwoStageParse() {
            ParseResult parseResult;
            block5: {
                parseResult = new ParseResult(this.input);
                PSDGrammarParser parser = this.createRecoveryParser(this.input, parseResult);
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                try {
                    this.ruleCallback.ruleCall(parser);
                }
                catch (Exception ex) {
                    if (this.interrupted) break block5;
                    ((CommonTokenStream)parser.getTokenStream()).reset();
                    parser.reset();
                    if (!SettingsHolder.IS_DEPLOYMENT_MODE) {
                        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
                    } else {
                        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                    }
                    parseResult.getParseErrors().clear();
                    this.ruleCallback.ruleCall(parser);
                    if (SettingsHolder.IS_DEPLOYMENT_MODE) break block5;
                    System.out.println("STAGE2 was needed for input '" + this.input + "'");
                }
            }
            if (!this.interrupted) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (parseResult.isInputValid()) {
                            listener.onValidationComplete(true);
                        } else {
                            listener.onRecoveryFinished(parseResult);
                        }
                    }
                });
            }
        }

        @Override
        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }
    }

    private class PsdGrammarBailLexer
    extends PsdGrammarLexerTranslated {
        public PsdGrammarBailLexer(CharStream input) {
            super(input);
        }

        @Override
        public void recover(RecognitionException re) {
            throw new RuntimeException(re);
        }

        @Override
        public void recover(LexerNoViableAltException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface RuleCallback {
        public void ruleCall(PSDGrammarParser var1);
    }
}

