/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.persistence.collector;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.network.URLPostUploader;
import cz.miroslavbartyzal.psdiagram.app.update.ArchiveUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class FlowchartCollector {
    private static final String SERVER_URL = SettingsHolder.PSDIAGRAM_SERVER + "/c";
    private boolean uploading = false;
    private boolean exitRequested = false;

    public void uploadFlowchart(String flowchartToSend, File file) {
        if (file == null) {
            return;
        }
        this.uploading = true;
        String fileName = file.getName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("u", System.getProperty("user.name"));
        try {
            params.put("h", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ex) {
            params.put("h", System.getenv().get("COMPUTERNAME"));
        }
        params.put("n", fileName);
        params.put("f", flowchartToSend);
        new Thread(() -> {
            Map<String, String> preparedParams = this.prepareParameters(params);
            new URLPostUploader().sendRequest(SERVER_URL, preparedParams, new URLPostUploader.UploadFinishListener(){

                @Override
                public void onUploadFinished(Integer httpResponseCode) {
                    FlowchartCollector.this.uploading = false;
                    if (FlowchartCollector.this.exitRequested) {
                        System.exit(0);
                    }
                }
            });
        }).start();
    }

    public void requestExitApp() {
        if (this.uploading) {
            this.exitRequested = true;
        } else {
            System.exit(0);
        }
    }

    public boolean isUploading() {
        return this.uploading;
    }

    private Map<String, String> prepareParameters(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            byte[] value = entry.getValue().getBytes(StandardCharsets.UTF_8);
            value = this.compress(value);
            value = this.encrypt(value);
            value = this.encode(value);
            String valuePrepared = "";
            if (value != null) {
                valuePrepared = new String(value, StandardCharsets.UTF_8);
            }
            result.put(entry.getKey(), valuePrepared);
        }
        return result;
    }

    private byte[] compress(byte[] input) {
        if (input == null) {
            return null;
        }
        try {
            return ArchiveUtil.compress(input);
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
    }

    private byte[] encrypt(byte[] input) {
        if (input == null) {
            return null;
        }
        return input;
    }

    private byte[] encode(byte[] input) {
        if (input == null) {
            return null;
        }
        return Base64.getEncoder().encode(input);
    }
}

