/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.persistence.recovery;

import cz.miroslavbartyzal.psdiagram.app.flowchart.layouts.Layout;
import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.persistence.FlowchartSaveContainer;
import cz.miroslavbartyzal.psdiagram.app.persistence.recovery.FlowchartRecovery;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FlowchartCrashRecovery {
    public static final String BACKUP_FILE_PREFIX = "backup_";
    private static final int TIMER_DELAY = 1000;
    private static final int MAX_BACKUPS_COUNT = 20;
    private final Layout layout;
    private final Marshaller jAXBmarshaller;
    private final ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private ByteArrayOutputStream backedUpFlowchart;
    private File backedUpActualFlowchartFile;
    private ByteArrayOutputStream savedFlowchart;
    private ScheduledFuture<?> task;
    private File backupFile = null;
    private RandomAccessFile backupRAFile = null;
    private FileLock backupFileLock = null;
    private boolean xmlMode = false;

    public FlowchartCrashRecovery(Layout layout, Marshaller jAXBmarshaller) {
        this.layout = layout;
        this.jAXBmarshaller = jAXBmarshaller;
    }

    public void startPolling() {
        this.task = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    FlowchartCrashRecovery.this.backupFlowchart();
                }
                catch (Throwable t) {
                    System.err.println("Caught exception in ScheduledExecutorService. StackTrace:\n" + Arrays.toString(t.getStackTrace()));
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void stopPolling() {
        if (this.task != null) {
            this.task.cancel(false);
            this.scheduledExecutorService.purge();
        }
    }

    public void updateSavedFlowchart() {
        if (SettingsHolder.settings.getActualFlowchartFile() != null) {
            this.xmlMode = SettingsHolder.settings.getActualFlowchartFile().getName().endsWith(".xml");
            try {
                this.savedFlowchart = new ByteArrayOutputStream();
                byte[] actualFFBytes = Files.readAllBytes(SettingsHolder.settings.getActualFlowchartFile().toPath());
                this.savedFlowchart.write(actualFFBytes, 0, actualFFBytes.length);
            }
            catch (Exception ex) {
                MyExceptionHandler.handle(ex);
                this.savedFlowchart = null;
            }
        } else {
            this.xmlMode = false;
            this.savedFlowchart = null;
        }
        this.backupFlowchart();
    }

    public void backupFlowchart() {
        block11: {
            if (this.layout.getFlowchart().getMainSegment().size() > 2) {
                try {
                    ByteArrayOutputStream currentFlowchart = new ByteArrayOutputStream();
                    if (this.xmlMode) {
                        this.jAXBmarshaller.marshal(this.layout.getFlowchart(), currentFlowchart);
                    } else {
                        this.jAXBmarshaller.marshal((Object)new FlowchartSaveContainer(this.layout.getFlowchart()), currentFlowchart);
                    }
                    if (this.savedFlowchart == null || !Arrays.equals(this.savedFlowchart.toByteArray(), currentFlowchart.toByteArray())) {
                        if (this.backedUpFlowchart == null || this.backedUpActualFlowchartFile == null && SettingsHolder.settings.getActualFlowchartFile() != null || this.backedUpActualFlowchartFile != null && !this.backedUpActualFlowchartFile.equals(SettingsHolder.settings.getActualFlowchartFile()) || !Arrays.equals(this.backedUpFlowchart.toByteArray(), currentFlowchart.toByteArray())) {
                            this.alocateBackupFile();
                            if (this.backupRAFile != null) {
                                try {
                                    this.backedUpActualFlowchartFile = SettingsHolder.settings.getActualFlowchartFile();
                                    this.backedUpFlowchart = currentFlowchart;
                                    ByteArrayOutputStream flowchartRecoveryBaos = new ByteArrayOutputStream();
                                    FlowchartRecovery flowchartRecovery = new FlowchartRecovery(new FlowchartSaveContainer(this.layout.getFlowchart()), this.backedUpActualFlowchartFile, SettingsHolder.settings.isDontSaveDirectly());
                                    this.jAXBmarshaller.marshal((Object)flowchartRecovery, flowchartRecoveryBaos);
                                    this.backupRAFile.getChannel().truncate(0L);
                                    this.backupRAFile.write(flowchartRecoveryBaos.toByteArray());
                                }
                                catch (IOException ex) {
                                    MyExceptionHandler.handle(ex);
                                }
                            }
                        }
                        break block11;
                    }
                    this.deleteBackup();
                }
                catch (JAXBException ex) {
                    MyExceptionHandler.handle(ex);
                }
            } else {
                this.deleteBackup();
            }
        }
    }

    private void alocateBackupFile() {
        if (this.backupRAFile == null) {
            for (int i = 1; i <= 20; ++i) {
                File file = new File(SettingsHolder.WORKING_DIR, BACKUP_FILE_PREFIX + i + ".xml");
                if (file.exists()) continue;
                RandomAccessFile raFile = null;
                try {
                    raFile = new RandomAccessFile(file, "rw");
                    FileLock fileLock = raFile.getChannel().tryLock();
                    if (fileLock != null) {
                        this.backupFile = file;
                        this.backupRAFile = raFile;
                        this.backupFileLock = fileLock;
                        break;
                    }
                    raFile.close();
                    continue;
                }
                catch (IOException | OverlappingFileLockException ex) {
                    if (raFile != null) {
                        try {
                            raFile.close();
                        }
                        catch (IOException ex1) {
                            MyExceptionHandler.handle(ex1);
                        }
                    }
                    MyExceptionHandler.handle(ex);
                    return;
                }
            }
        }
    }

    public void realocateBackupFile(String filename) {
        File file;
        if (filename.matches("backup_[0-9]+\\.xml") && (file = new File(SettingsHolder.WORKING_DIR, filename)).exists()) {
            RandomAccessFile raFile = null;
            try {
                raFile = new RandomAccessFile(file, "rw");
                FileLock fileLock = raFile.getChannel().tryLock();
                if (fileLock != null) {
                    this.deleteBackup();
                    this.backupFile = file;
                    this.backupRAFile = raFile;
                    this.backupFileLock = fileLock;
                    this.backupFlowchart();
                } else {
                    raFile.close();
                }
            }
            catch (IOException | OverlappingFileLockException ex) {
                if (raFile != null) {
                    try {
                        raFile.close();
                    }
                    catch (IOException ex1) {
                        MyExceptionHandler.handle(ex1);
                    }
                }
                MyExceptionHandler.handle(ex);
            }
        }
    }

    public boolean isFlowchartRestorationAvailable() {
        for (int i = 1; i <= 20; ++i) {
            File file = new File(SettingsHolder.WORKING_DIR, BACKUP_FILE_PREFIX + i + ".xml");
            if (!file.exists()) continue;
            RandomAccessFile raFile = null;
            try {
                raFile = new RandomAccessFile(file, "rw");
                FileLock fileLock = raFile.getChannel().tryLock();
                if (fileLock != null) {
                    fileLock.release();
                    raFile.close();
                    return true;
                }
                raFile.close();
                continue;
            }
            catch (IOException | OverlappingFileLockException ex) {
                if (raFile != null) {
                    try {
                        raFile.close();
                    }
                    catch (IOException ex1) {
                        MyExceptionHandler.handle(ex1);
                    }
                }
                MyExceptionHandler.handle(ex);
            }
        }
        return false;
    }

    public void deleteBackup() {
        if (this.backupRAFile != null && this.backupFile.exists()) {
            if (this.backupFileLock != null) {
                try {
                    this.backupFileLock.release();
                }
                catch (IOException ex) {
                    MyExceptionHandler.handle(ex);
                }
            }
            try {
                this.backupRAFile.close();
            }
            catch (IOException ex) {
                MyExceptionHandler.handle(ex);
            }
            this.backupFile.delete();
        }
        this.backupFile = null;
        this.backupRAFile = null;
        this.backupFileLock = null;
        this.backedUpFlowchart = null;
        this.backedUpActualFlowchartFile = null;
    }

    public List<File> getFilesToRestore() {
        ArrayList<File> filesToRestore = new ArrayList<File>();
        for (int i = 1; i <= 20; ++i) {
            File file = new File(SettingsHolder.WORKING_DIR, BACKUP_FILE_PREFIX + i + ".xml");
            if (!file.exists()) continue;
            RandomAccessFile raFile = null;
            try {
                raFile = new RandomAccessFile(file, "rw");
                FileLock fileLock = raFile.getChannel().tryLock();
                if (fileLock != null) {
                    fileLock.release();
                    raFile.close();
                    filesToRestore.add(file);
                    continue;
                }
                raFile.close();
                continue;
            }
            catch (IOException | OverlappingFileLockException ex) {
                if (raFile != null) {
                    try {
                        raFile.close();
                    }
                    catch (IOException ex1) {
                        MyExceptionHandler.handle(ex1);
                    }
                }
                MyExceptionHandler.handle(ex);
            }
        }
        return filesToRestore;
    }
}

