/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.update;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ArchiveUtil {
    private static final int BUFFER = 0x100000;

    public static byte[] compress(byte[] data) throws IOException {
        Deflater deflater = new Deflater(-1, true);
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    public static byte[] zip(byte[] input, String fileName) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            ZipEntry entry = new ZipEntry(fileName);
            zos.putNextEntry(entry);
            zos.write(input);
            zos.closeEntry();
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractZIP(File zipFile, boolean extractHere, Charset charset) throws ZipException, IOException, IllegalArgumentException {
        File extractionDir;
        try (ZipFile zip = new ZipFile(zipFile, charset);){
            extractionDir = extractHere ? zipFile.getParentFile() : new File(zipFile.getAbsolutePath().substring(0, zipFile.getAbsolutePath().length() - 4));
            if (!extractHere) {
                if (extractionDir.exists()) {
                    ArchiveUtil.delete(extractionDir);
                }
                extractionDir.mkdir();
            }
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(extractionDir, currentEntry);
                if (destFile.exists()) {
                    destFile.delete();
                }
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = null;
                FileOutputStream fos = null;
                FilterOutputStream dest = null;
                try {
                    int currentByte;
                    is = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] data = new byte[0x100000];
                    fos = new FileOutputStream(destFile);
                    dest = new BufferedOutputStream(fos, 0x100000);
                    while ((currentByte = is.read(data)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, currentByte);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                finally {
                    if (dest != null) {
                        dest.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return extractionDir;
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                ArchiveUtil.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }
}

