/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.update;

import cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters.MapChangesAdapter;
import cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters.MapChangesCalendarAdapter;
import cz.miroslavbartyzal.psdiagram.app.global.xmlAdapters.MapListChangesAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;

@XmlRootElement(name="versionsinfo")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="versionsinfo")
public class ChangesCondenser {
    private String topVersion = null;
    private String bottomVersion = null;
    @XmlCDATA
    @XmlElement(name="changelogurl")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String changlelogURL;
    @XmlElement(name="releasedates")
    @XmlJavaTypeAdapter(value=MapChangesCalendarAdapter.class)
    private Map<String, Calendar> releaseDates;
    @XmlElement(name="releaseurl")
    @XmlJavaTypeAdapter(value=MapChangesAdapter.class)
    private Map<String, String> releaseURLs;
    @XmlElement(name="headlines")
    @XmlJavaTypeAdapter(value=MapChangesAdapter.class)
    private Map<String, String> headlines;
    @XmlElement(name="descriptions")
    @XmlJavaTypeAdapter(value=MapChangesAdapter.class)
    private Map<String, String> descriptions;
    @XmlElement(name="features")
    @XmlJavaTypeAdapter(value=MapListChangesAdapter.class)
    private Map<String, List<String>> features;
    @XmlElement(name="enhancements")
    @XmlJavaTypeAdapter(value=MapListChangesAdapter.class)
    private Map<String, List<String>> enhancements;
    @XmlElement(name="extensions")
    @XmlJavaTypeAdapter(value=MapListChangesAdapter.class)
    private Map<String, List<String>> extensions;
    @XmlElement(name="changes")
    @XmlJavaTypeAdapter(value=MapListChangesAdapter.class)
    private Map<String, List<String>> changes;
    @XmlElement(name="fixes")
    @XmlJavaTypeAdapter(value=MapListChangesAdapter.class)
    private Map<String, List<String>> fixes;
    @XmlElement(name="others")
    @XmlJavaTypeAdapter(value=MapListChangesAdapter.class)
    private Map<String, List<String>> other;

    public ChangesCondenser() {
        this(null, null, null, null, null, null, null, null, null, null, null);
    }

    public ChangesCondenser(String changlelogURL, Map<String, Calendar> releaseDates, Map<String, String> releaseURLs, Map<String, String> headlines, Map<String, String> descriptions, Map<String, List<String>> features, Map<String, List<String>> enhancements, Map<String, List<String>> extensions, Map<String, List<String>> changes, Map<String, List<String>> fixes, Map<String, List<String>> other) {
        this.changlelogURL = changlelogURL;
        this.releaseDates = releaseDates;
        this.releaseURLs = releaseURLs;
        this.headlines = headlines;
        this.descriptions = descriptions;
        this.features = features;
        this.enhancements = enhancements;
        this.extensions = extensions;
        this.changes = changes;
        this.fixes = fixes;
        this.other = other;
    }

    public String getChanglelogURL() {
        return this.changlelogURL;
    }

    public Map<String, Calendar> getReleaseDates() {
        return this.releaseDates;
    }

    public Map<String, String> getReleaseURLs() {
        return this.releaseURLs;
    }

    public Map<String, String> getHeadlines() {
        return this.headlines;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public Map<String, List<String>> getFeatures() {
        return this.features;
    }

    public Map<String, List<String>> getEnhancements() {
        return this.enhancements;
    }

    public Map<String, List<String>> getExtensions() {
        return this.extensions;
    }

    public Map<String, List<String>> getChanges() {
        return this.changes;
    }

    public Map<String, List<String>> getFixes() {
        return this.fixes;
    }

    public Map<String, List<String>> getOther() {
        return this.other;
    }

    public String getTopVersion() {
        if (this.topVersion == null) {
            this.setTopBottomVersions();
        }
        return this.topVersion;
    }

    public String getBottomVersion() {
        if (this.bottomVersion == null) {
            this.setTopBottomVersions();
        }
        return this.bottomVersion;
    }

    public ChangesCondenser getFractionCondenser(String afterVersion) {
        float fv = ChangesCondenser.parseVersion(afterVersion);
        return new ChangesCondenser(this.changlelogURL, this.getFractionMap(fv, this.releaseDates), this.getFractionMap(fv, this.releaseURLs), this.getFractionMap(fv, this.headlines), this.getFractionMap(fv, this.descriptions), this.getFractionMap(fv, this.features), this.getFractionMap(fv, this.enhancements), this.getFractionMap(fv, this.extensions), this.getFractionMap(fv, this.changes), this.getFractionMap(fv, this.fixes), this.getFractionMap(fv, this.other));
    }

    private <E> Map<String, E> getFractionMap(float afterVersion, Map<String, E> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, E> retMAP = new HashMap<String, E>(map);
        Iterator<Map.Entry<String, E>> it = retMAP.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, E> entry = it.next();
            if (!(ChangesCondenser.parseVersion(entry.getKey()) <= afterVersion)) continue;
            it.remove();
        }
        return retMAP;
    }

    public static float parseVersion(String version) {
        String ver = version.replaceAll("[^0-9]", "");
        return Float.parseFloat(ver.substring(0, 1) + "." + ver.substring(1));
    }

    public TreeSet<String> getAllVersions() {
        TreeSet<String> versions = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Float versionNumber1 = Float.valueOf(ChangesCondenser.parseVersion(o1));
                Float versionNumber2 = Float.valueOf(ChangesCondenser.parseVersion(o2));
                return versionNumber2.compareTo(versionNumber1);
            }
        });
        if (this.releaseDates != null) {
            versions.addAll(this.releaseDates.keySet());
        }
        if (this.releaseURLs != null) {
            versions.addAll(this.releaseURLs.keySet());
        }
        if (this.headlines != null) {
            versions.addAll(this.headlines.keySet());
        }
        if (this.descriptions != null) {
            versions.addAll(this.descriptions.keySet());
        }
        if (this.features != null) {
            versions.addAll(this.features.keySet());
        }
        if (this.enhancements != null) {
            versions.addAll(this.enhancements.keySet());
        }
        if (this.extensions != null) {
            versions.addAll(this.extensions.keySet());
        }
        if (this.changes != null) {
            versions.addAll(this.changes.keySet());
        }
        if (this.fixes != null) {
            versions.addAll(this.fixes.keySet());
        }
        if (this.other != null) {
            versions.addAll(this.other.keySet());
        }
        return versions;
    }

    private void setTopBottomVersions() {
        float top = -9.223372E18f;
        float bottom = 9.223372E18f;
        TreeSet<String> versions = this.getAllVersions();
        for (String version : versions) {
            float versionNumber = ChangesCondenser.parseVersion(version);
            if (versionNumber > top) {
                top = versionNumber;
                this.topVersion = version;
            }
            if (!(versionNumber < bottom)) continue;
            bottom = versionNumber;
            this.bottomVersion = version;
        }
    }
}

