/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.update;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.update.ChangesCondenser;
import cz.miroslavbartyzal.psdiagram.app.update.JAXBUpdateContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.util.JAXBSource;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class CondenserToHTMLConverter {
    public static String convertToHTML(ChangesCondenser changesCondenser, Charset charset) {
        Transformer transformer;
        JAXBSource source;
        try {
            source = new JAXBSource(JAXBUpdateContext.getMarshaller(), (Object)changesCondenser);
        }
        catch (JAXBException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        TransformerFactory tf = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(CondenserToHTMLConverter.class.getResourceAsStream("/psdiagram_changes.xsl"));
        try {
            transformer = tf.newTransformer(xslt);
            transformer.setOutputProperty("encoding", charset.name());
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
        }
        catch (TransformerConfigurationException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            MyExceptionHandler.handle(ex);
            return null;
        }
        return new String(((ByteArrayOutputStream)result.getOutputStream()).toByteArray(), charset);
    }
}

