/*
 * Decompiled with CFR 0.152.
 */
package cz.miroslavbartyzal.psdiagram.app.update;

import cz.miroslavbartyzal.psdiagram.app.global.MyExceptionHandler;
import cz.miroslavbartyzal.psdiagram.app.global.SettingsHolder;
import cz.miroslavbartyzal.psdiagram.app.network.URLFileDownloader;
import cz.miroslavbartyzal.psdiagram.app.network.URLStringDownloader;
import cz.miroslavbartyzal.psdiagram.app.update.ArchiveUtil;
import cz.miroslavbartyzal.psdiagram.app.update.ChangesCondenser;
import cz.miroslavbartyzal.psdiagram.app.update.CondenserToHTMLConverter;
import cz.miroslavbartyzal.psdiagram.app.update.FileChecksum;
import cz.miroslavbartyzal.psdiagram.app.update.JAXBUpdateContext;
import jakarta.xml.bind.JAXBException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public final class Updater {
    private static final String ARCHIVE_NAME = "update.zip";
    private static final String UPDATER_FILENAME = "updater.jar";
    private static final String[] UPDATER_FILES_TO_REMOVE = new String[]{"updater.bat", "dirfootprint.xml"};
    private String changesHTML;
    private ChangesCondenser changesCondenser;
    private URLFileDownloader uRLFileDownloader;

    public void loadInfo(final PropertyChangeListener statusListener, final InfoLoadListener infoLoadListener) {
        new Thread(() -> {
            this.cleanAfterSelf();
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put("since", SettingsHolder.PSDIAGRAM_VERSION);
            URLStringDownloader uRLStringDownloader = new URLStringDownloader();
            uRLStringDownloader.addPropertyChangeListener(statusListener);
            uRLStringDownloader.sendRequest(SettingsHolder.PSDIAGRAM_SERVER + "/versioninfo", vars, new URLStringDownloader.DownloadFinishListener(){

                @Override
                public void onDownloadFinished(String result, Charset charset) {
                    new Thread(() -> {
                        Boolean newVersionAvailable;
                        if (result == null) {
                            newVersionAvailable = null;
                        } else {
                            if (!result.isEmpty()) {
                                try {
                                    Updater.this.changesCondenser = (ChangesCondenser)JAXBUpdateContext.getUnmarshaller().unmarshal(new ByteArrayInputStream(result.getBytes(charset)));
                                }
                                catch (JAXBException ex) {
                                    MyExceptionHandler.handle(ex);
                                    statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "chyba p\u0159i konverzi xml"));
                                }
                                if (Updater.this.changesCondenser != null) {
                                    Updater.this.changesHTML = CondenserToHTMLConverter.convertToHTML(Updater.this.changesCondenser, charset);
                                }
                            }
                            newVersionAvailable = Updater.this.hasNewerVersion();
                        }
                        SwingUtilities.invokeLater(() -> infoLoadListener.onInfoLoaded(newVersionAvailable));
                    }).start();
                }
            });
        }).start();
    }

    public void downloadAndInstallUdate(final PropertyChangeListener statusListener, final BeforeExitListener beforeExitListener) throws IllegalStateException {
        if (!this.hasNewerVersion()) {
            throw new IllegalStateException("Can't init download without any version info. Please invoke loadInfo method first.");
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("version", this.getVersionAvailable());
        this.uRLFileDownloader = new URLFileDownloader();
        this.uRLFileDownloader.addPropertyChangeListener(statusListener);
        this.uRLFileDownloader.sendRequest(SettingsHolder.PSDIAGRAM_SERVER + "/download", vars, SettingsHolder.WORKING_DIR, ARCHIVE_NAME, new URLFileDownloader.DownloadFinishListener(){

            @Override
            public void onDownloadFinished(File downloadedFile) {
                if (downloadedFile != null) {
                    statusListener.propertyChange(new PropertyChangeEvent(this, "status", null, "ov\u011b\u0159uji kontroln\u00ed sou\u010det"));
                    HashMap<String, String> vars = new HashMap<String, String>();
                    vars.put("checksum", Updater.this.getVersionAvailable());
                    vars.put("alg", "MD5");
                    URLStringDownloader uRLStringDownloader = new URLStringDownloader();
                    uRLStringDownloader.sendRequest(SettingsHolder.PSDIAGRAM_SERVER + "/download", vars, new ChecksumCheck(downloadedFile, statusListener, beforeExitListener));
                }
            }
        });
    }

    public void cancelDownloadAndInstallUdate() {
        this.uRLFileDownloader.cancel(false);
    }

    public String getVersionAvailable() {
        if (this.changesCondenser != null) {
            return this.changesCondenser.getTopVersion();
        }
        return null;
    }

    public String getChangesHTML() {
        return this.changesHTML;
    }

    public boolean hasNewerVersion() {
        return this.changesCondenser != null && ChangesCondenser.parseVersion(this.getVersionAvailable()) > ChangesCondenser.parseVersion(SettingsHolder.PSDIAGRAM_VERSION);
    }

    public ChangesCondenser getChangesCondenser() {
        return this.changesCondenser;
    }

    private void launchUpdate(File downloadedFile, final PropertyChangeListener statusListener, final BeforeExitListener beforeExitListener) {
        File extractedDir;
        statusListener.propertyChange(new PropertyChangeEvent(this, "status", null, "extrahuji..."));
        try {
            extractedDir = ArchiveUtil.extractZIP(downloadedFile, true, Charset.defaultCharset());
        }
        catch (IOException ex) {
            MyExceptionHandler.handle(ex);
            statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "chyba p\u0159i extrahov\u00e1n\u00ed instal\u00e1toru"));
            return;
        }
        catch (IllegalArgumentException ex) {
            try {
                extractedDir = ArchiveUtil.extractZIP(downloadedFile, true, StandardCharsets.UTF_8);
            }
            catch (IOException | IllegalArgumentException ex2) {
                MyExceptionHandler.handle(ex);
                statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "chyba p\u0159i extrahov\u00e1n\u00ed instal\u00e1toru"));
                return;
            }
        }
        downloadedFile.delete();
        statusListener.propertyChange(new PropertyChangeEvent(this, "status", null, "p\u0159ipravuji spu\u0161t\u011bn\u00ed instalace..."));
        final File updaterFile = new File(extractedDir, UPDATER_FILENAME);
        if (!updaterFile.exists()) {
            statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "chyba: nenalezen instal\u00e1tor"));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                beforeExitListener.onBeforeExit();
                try {
                    if (SettingsHolder.JAVAW == null) {
                        String command = "start \"updater\" /d \"" + updaterFile.getParentFile().getAbsolutePath() + "\" \"" + updaterFile.getAbsolutePath() + "\" -psdir \"" + SettingsHolder.MY_DIR.getAbsolutePath() + "\"";
                        Runtime.getRuntime().exec(new String[]{"cmd", "/s", "/c", "\"" + command + "\""});
                    } else {
                        String command = "start \"updater\" /d \"" + updaterFile.getParentFile().getAbsolutePath() + "\" \"" + SettingsHolder.JAVAW.getAbsolutePath() + "\" -jar \"" + updaterFile.getAbsolutePath() + "\" -psdir \"" + SettingsHolder.MY_DIR.getAbsolutePath() + "\"";
                        Runtime.getRuntime().exec(new String[]{"cmd", "/s", "/c", "\"" + command + "\""}, null, updaterFile.getParentFile());
                    }
                }
                catch (IOException ex) {
                    MyExceptionHandler.handle(ex);
                    statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "chyba p\u0159i spou\u0161t\u011bn\u00ed instal\u00e1toru"));
                    return;
                }
                System.exit(0);
            }
        });
    }

    private void cleanAfterSelf() {
        try {
            new File(SettingsHolder.WORKING_DIR, ARCHIVE_NAME).delete();
            new File(SettingsHolder.WORKING_DIR, UPDATER_FILENAME).delete();
            for (String str : UPDATER_FILES_TO_REMOVE) {
                new File(SettingsHolder.WORKING_DIR, str).delete();
            }
            ArchiveUtil.delete(new File(SettingsHolder.WORKING_DIR, ARCHIVE_NAME.substring(0, ARCHIVE_NAME.length() - 4)));
            ArchiveUtil.delete(new File(SettingsHolder.WORKING_DIR, "oldjre"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface BeforeExitListener {
        public void onBeforeExit();
    }

    public static interface InfoLoadListener {
        public void onInfoLoaded(Boolean var1);
    }

    private class ChecksumCheck
    implements URLStringDownloader.DownloadFinishListener {
        private final File downloadedFile;
        private final PropertyChangeListener statusListener;
        private final BeforeExitListener beforeExitListener;

        public ChecksumCheck(File downloadedFile, PropertyChangeListener statusListener, BeforeExitListener beforeExitListener) {
            this.downloadedFile = downloadedFile;
            this.statusListener = statusListener;
            this.beforeExitListener = beforeExitListener;
        }

        @Override
        public void onDownloadFinished(final String result, Charset charset) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String checksum = FileChecksum.getMD5Checksum(ChecksumCheck.this.downloadedFile);
                    if (result == null || checksum == null) {
                        ChecksumCheck.this.statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "chyba: nepoda\u0159ilo se ov\u011b\u0159it kontroln\u00ed sou\u010det"));
                        return;
                    }
                    if (!result.equals(checksum)) {
                        ChecksumCheck.this.statusListener.propertyChange(new PropertyChangeEvent(this, "error", null, "kontroln\u00ed sou\u010det nesouhlas\u00ed"));
                        return;
                    }
                    ChecksumCheck.this.statusListener.propertyChange(new PropertyChangeEvent(this, "status", null, "kontroln\u00ed sou\u010det ov\u011b\u0159en"));
                    Updater.this.launchUpdate(ChecksumCheck.this.downloadedFile, ChecksumCheck.this.statusListener, ChecksumCheck.this.beforeExitListener);
                }
            }).start();
        }
    }
}

