/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.util.HashMap;
import java.util.Map;

public enum LogLevel {
    ALL(0, "ALL"),
    FINEST(1, "FINEST"),
    FINER(2, "FINER"),
    FINE(3, "FINE"),
    CONFIG(4, "CONFIG"),
    INFO(5, "INFO"),
    WARNING(6, "WARNING"),
    SEVERE(7, "SEVERE"),
    OFF(8, "OFF");

    public static final int length;
    private static final Map<String, LogLevel> stringValuesMap;
    private static final LogLevel[] idValues;
    private final byte id;
    private final String name;

    public static final LogLevel toValue(String name) {
        return name != null ? stringValuesMap.get(name.toUpperCase()) : null;
    }

    public static final LogLevel toValue(String name, LogLevel fallBack) {
        if (name != null) {
            LogLevel level = stringValuesMap.get(name.toUpperCase());
            return level != null ? level : fallBack;
        }
        return fallBack;
    }

    public static final LogLevel toValue(int id) {
        if (id < 0 || id >= length) {
            throw new IllegalArgumentException("Log level ID " + id + "is out of range <0, " + Integer.toString(length) + ">.");
        }
        return idValues[id];
    }

    public static final LogLevel toValue(int id, LogLevel fallBack) {
        if (id >= 0 && id < length) {
            return idValues[id];
        }
        return fallBack;
    }

    private LogLevel(byte id, String name) {
        this.id = id;
        this.name = name;
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldLog(LogLevel level) {
        return this.id <= level.id;
    }

    public boolean shouldLog(byte id) {
        return this.id <= id;
    }

    static {
        length = LogLevel.values().length;
        stringValuesMap = new HashMap<String, LogLevel>(2 * length);
        for (LogLevel logLevel : LogLevel.values()) {
            stringValuesMap.put(logLevel.name.toUpperCase(), logLevel);
        }
        idValues = new LogLevel[length];
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        for (int i = 0; i < n; ++i) {
            LogLevel logLevel;
            LogLevel.idValues[logLevel.id] = logLevel = logLevelArray[i];
        }
    }
}

